<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        if (!Schema::hasTable('cancel_booking')) {
            Schema::create('cancel_booking', function (Blueprint $table) {
                $table->id();
                $table->unsignedBigInteger('user_id')->default(0);
                $table->unsignedBigInteger('hotel_id')->default(0);
                $table->unsignedBigInteger('booking_id')->default(0);
                $table->text('reason')->nullable();
                $table->enum('status', [1, 0])->default(1);
                $table->timestamps();
                $table->softDeletes();
                
                // Adding indexes
                $table->index('user_id');
                $table->index('hotel_id');
                $table->index('reason');
                
                // Foreign key constraints
                $table->foreign('user_id')->references('id')->on('users')->onDelete('cascade');
                $table->foreign('hotel_id')->references('id')->on('hotels')->onDelete('cascade');
                $table->foreign('booking_id')->references('id')->on('bookings')->onDelete('cascade');
            });
        }
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('cencel_booking');
    }
};
