<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        if (!Schema::hasTable('aminities')) {
            Schema::create('aminities', function (Blueprint $table) {
                $table->id();
                $table->string('name')->nullable();
                $table->string('image')->nullable();
                $table->text('short_description')->nullable();
                $table->enum('status',[1,0])->default(1);
                $table->timestamps();
                $table->softDeletes();

                $table->index('name');
                $table->index('image');
                $table->index('short_description');
                $table->index('status');
                $table->index('created_at');
                $table->index('updated_at');
            });
        }
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('aminities');
    }
};
