<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use DB;

class Booking extends Model
{
    use HasFactory;
    use SoftDeletes;
    protected $guarded = ['id'];
    protected $table = "bookings";
    
    public function user()
    {
        return $this->belongsTo(User::class);
    }
    
    public function cancelBookings()
    {
        return $this->hasMany(CancelBooking::class);
    }

    public function hotel()
    {
        return $this->belongsTo(Hotel::class);
    }

    public function package()
    {
        return $this->belongsTo(Package::class);
    }

    public function booking_guests()
    {
        return $this->hasMany(BookingGuest::class);
    }
    
    /**
     * Fetch list of from here
    **/
    public static function getLists($search)
    {
        try {
            $obj = new self;

            $pagination = (isset($search['perpage'])) ? $search['perpage'] : config('constant.pagination');

            if (isset($search['status']) && $search['status'] !== '') {
                $obj = $obj->where('status', $search['status']);
            }
        
            $data = $obj->with(['user','hotel'])->orderBy('id', 'DESC')->paginate($pagination)->appends('perpage', $pagination);

            return $data;
        } catch (\Exception $e) {
            return ['status' => false, 'message' => $e->getMessage() . ' ' . $e->getLine() . ' ' . $e->getFile()];
        }
    }
    
    /**
     * Delete particular
    **/
    public static function deleteRecord($id) {
        try {
            $obj = new self;    
            $obj->where('id',$id)->delete();   
            return ['status' => true, 'message' => __('lang.admin_data_delete_msg')];
        }
        catch (\Exception $e) {
            return ['status' => false, 'message' => $e->getMessage() . ' '. $e->getLine() . ' '. $e->getFile()];
        }
    }
    
    /**
     * Update Columns 
    **/
    public static function updateColumn($id){
        try {
            $data = self::where('id', $id)->first();

            // Assuming 'status' is an ENUM column with values '0' and '1'
            $newStatus = ($data->status == '1') ? '0' : '1';

            $data->update(['status' => $newStatus]);

            return ['status' => true, 'message' => __('lang.admin_data_change_msg')];
        } catch (\Exception $e) {
            return ['status' => false, 'message' => $e->getMessage() . ' ' . $e->getLine() . ' ' . $e->getFile()];
        }
    }
}
