<?php

namespace App\Http\Controllers\Admin;
use App\Http\Controllers\Controller;
use App\Models\Vendor;
use App\Models\Wallet;
use Illuminate\Http\Request;
use Session;
use DB;
class VendorController extends Controller
{
    /**
     * Show the list.
     **/
    public function vendorList(Request $request)
    {
        try{
            $data['result'] = Vendor::getVendorLists($request->all());
            $data['statusTypes'] = \Helpers::getStatusType();
            return view('admin.vendor.list',$data);
        }
        catch(\Exception $ex){
            return redirect()->back()->with('error', $ex->getMessage() . ' '. $ex->getLine() . ' '. $ex->getFile()); 
        }
    }
    
    /**
     * Fetch list from here
    **/
    public static function getVendorLists($search)
    {
        try { 
            $obj = new self;
            $pagination = (isset($search['perpage']))?$search['perpage']:config('constant.pagination');
            if(isset($search['name']) && !empty($search['name'])){
                 $obj = $obj->orWhere('name', 'like', '%'.trim($search['name']).'%')
                           ->orWhere('email', 'like', '%'.trim($search['name']).'%');
            }
            if(isset($search['status']) && $search['status']!=''){
                $obj = $obj->where('status',$search['status']);
            }
            $data = $obj->where('type','vendor')->orderBy('id', 'DESC')->paginate($pagination)->appends('perpage', $pagination);
            return $data;
        }
        catch (\Exception $e) {
            return ['status' => false, 'message' => $e->getMessage() . ' '. $e->getLine() . ' '. $e->getFile()];
        }
    }
    
    /**
     * View the specified record.
     *
     * @param  id  $id
     * @return \Illuminate\Http\Response
    **/
     public function updateColumn($id)
    {
        try{
            $updated = Vendor::updateColumn($id);
            if($updated['status']==true){
                return redirect()->back()->with('success', $updated['message']);
            }
            else{
                return redirect()->back()->with('error', $updated['message']);
            } 
        }
        catch(\Exception $ex){
            return redirect()->back()->with('error', $ex->getMessage() . ' '. $ex->getLine() . ' '. $ex->getFile()); 
        }
    }
    
    
    public function update(Request $request)
    {
        try{
            $updated = Vendor::addUpdate($request->all(),$request->input('id'));
            if($updated['status']==true){
                return redirect('admin/vendor')->with('success', $updated['message']); 
            }
            else{
                return redirect()->back()->with('error', $updated['message']);
            } 
        }
        catch(\Exception $ex){
            return redirect()->back()->with('error', $ex->getMessage() . ' '. $ex->getLine() . ' '. $ex->getFile()); 
        }
    }
    
  
    public function destroy($id)
    {
        try{
            $deleted = Vendor::deleteRecord($id);
            if($deleted['status']==true){
                return redirect()->back()->with('success', $deleted['message']);
            }
            else{
                return redirect()->back()->with('error', $deleted['message']);
            } 
        }
        catch(\Exception $ex){
            return redirect()->back()->with('error', $ex->getMessage() . ' '. $ex->getLine() . ' '. $ex->getFile()); 
        }
    }

}
