<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Category;
use App\Models\Package;
use App\Models\Hotel;
use App\Models\Aminity;
use App\Models\Hotel_Packages;
use App\Models\Destination;
use Session;
use Illuminate\Support\Facades\Response;
use Illuminate\Support\Facades\Validator;

class HotelController extends Controller
{
    /**
     * Display a listing.
     * @param \Illuminate\Http\Request $request
     * @return \Illuminate\Http\Response
    **/
    public function index(Request $request)
    {
        try{
            $data['category_data'] = Category::where('status','1')->get();
            $data['destination_data'] = Destination::where('status','1')->get();
            $data['statusTypes'] = \Helpers::getStatusType();
            $data['result'] = Hotel::getLists($request->all());
            $data['hotelData'] = Hotel::get();
            $data['getType'] = \Helpers::getType();
            $data['package_data'] = Package::where('status','1')->get();
            return view('admin.hotel.list',$data);
        }
        catch(\Exception $ex){
            return redirect()->back()->with('error', $ex->getMessage() . ' '. $ex->getLine() . ' '. $ex->getFile()); 
        }
    }

    /**
     * Display a page.
     * @param \Illuminate\Http\Request $request
     * @return \Illuminate\Http\Response
    **/
    public function create(Request $request)
    { 
        $data['category_data'] = Category::where('status','1')->get();
        $data['package_data'] = Package::where('status','1')->get();
        $data['destination_data'] = Destination::where('status','1')->get();
        $data['aminity_data'] = Aminity::where('status','1')->get();
        $data['getType'] = \Helpers::getType();
        return view('admin.hotel.create',$data);
    }


    /**
     * Store a newly created resource.
     *
     * @param  \App\Http\Requests\Store  $request
     * @return \Illuminate\Http\Response
    **/

    public function store(Request $request)
    {
        // dd($request->all());
        try{
            $added = Hotel::addUpdate($request->all());
            if($added['status']==true){
                Session::flash('success', $added['message']);
                return redirect('admin/hotel')->with('success', $added['message']); 
            }
            else{
                return redirect()->back()->with('error', $added['message']);
            }
        }
        catch(\Exception $ex){
            return redirect()->back()->with('error', $ex->getMessage() . ' '. $ex->getLine() . ' '. $ex->getFile()); 
        }
    }


    /**
     * Display a edit listing.
     * @param \Illuminate\Http\Request $request
     * @return \Illuminate\Http\Response
    **/
    public function edit(Request $request,$id)
    {
        try{
            $data['result'] = Hotel::with('additionalInfos','destination','cancellationPolicies','specification','hotelAminities','hotelPackages','hotelImages')->where('id',$id)->first();
            $data['category_data'] = Category::where('status','1')->get();
            $data['package_data'] = Package::where('status','1')->get();
            $data['destination_data'] = Destination::where('status','1')->get();
            $data['aminity_data'] = Aminity::where('status','1')->get();
            $data['getType'] = \Helpers::getType();
            return view('admin.hotel.edit',$data);
        }
        catch(\Exception $ex){
            return redirect()->back()->with('error', $ex->getMessage() . ' '. $ex->getLine() . ' '. $ex->getFile()); 
        }
    }

    /**
     * Update the specified in storage.
     *
     * @param  \App\Http\Requests\UpdateRequest  $request
     * @param  id  $id
     * @return \Illuminate\Http\Response
    **/
    public function update(Request $request)
    {
        try{

            $validator = Validator::make($request->all(), [
                'name' => 'required|string|max:255|unique:restaurants,name,' . $id,
                'email' => 'required|email|unique:restaurants,email,' . $id,
                'tax' => 'required|numeric',
                'minimum_time' => 'required|numeric',
                'maximum_time' => 'required|numeric',
                'time_type' => 'required|in:hours,minutes',
                'tin_number' => 'nullable|numeric',
                'date' => 'nullable|date',
                'area_id' => 'required|exists:areas,id',
                'latitude' => 'required|string',
                'longitude' => 'required|string',
                'owner_first_name' => 'required|string',
                'owner_last_name' => 'required|string',
                'owner_phone' => 'required|numeric|digits:10',
            ]);

            if ($validator->fails()) {
                return redirect()->back()->withErrors($validator)->withInput();
            }

            $updated = Restaurant::addUpdate($request->all(),$request->input('id'));
            if($updated['status']==true){
                return redirect('admin/hotel')->with('success', $updated['message']); 
            }
            else{
                return redirect()->back()->with('error', $updated['message']);
            } 
        }
        catch(\Exception $ex){
            return redirect()->back()->with('error', $ex->getMessage() . ' '. $ex->getLine() . ' '. $ex->getFile()); 
        }
    }

    /**
     * Remove the specified from storage.
     *
     * @param  id  $id
     * @return \Illuminate\Http\Response
    **/
    public function destroy($id)
    {
        try{
            $deleted = Restaurant::deleteRecord($id);
            
            if($deleted['status']==true){
                return redirect()->back()->with('success', $deleted['message']); 
            }
            else{
                return redirect()->back()->with('error', $deleted['message']);
            } 
        }
        catch(\Exception $ex){
            return redirect()->back()->with('error', $ex->getMessage() . ' '. $ex->getLine() . ' '. $ex->getFile()); 
        }
    }
    
    public function destroyData($id)
    {
        try {
            // Ensure you have 'type' in your request
            $type = request()->query('type', 'additional-delete'); // Default to 'additional-delete'
    
            $deleted = false;
    
            if ($type === 'additional-delete') {
                $deleted = Additional_Info::deleteRecord($id);
            }
            if ($deleted['status'] === true) {
                return redirect()->back()->with('success', $deleted['message']);
            } else {
                return redirect()->back()->with('error', $deleted['message']);
            }
        } catch (\Exception $ex) {
            return redirect()->back()->with('error', $ex->getMessage() . ' ' . $ex->getLine() . ' ' . $ex->getFile());
        }
    }


    /**
     * Remove the specified from storage.
     *
     * @param  id  $id
     * @return \Illuminate\Http\Response
    **/
    public function updateColumn($id)
    {
        try{
            $updated = Restaurant::updateColumn($id);
            if($updated['status']==true){
                return redirect()->back()->with('success', $updated['message']); 
            }
            else{
                return redirect()->back()->with('error', $updated['message']);
            } 
        }
        catch(\Exception $ex){
            return redirect()->back()->with('error', $ex->getMessage() . ' '. $ex->getLine() . ' '. $ex->getFile()); 
        }
    }

    /**
     * view the specified from storage.
     *
     * @param  id  $id
     * @return \Illuminate\Http\Response
    **/

        public function viewRestaurant(Request $request,$id)
    {
        try{
            $data['result'] = Restaurant::with('cuisines')->where('id',$id)->first();
            $data['itemData'] = Item::getLists($request->all())->where('restaurant_id',$id);
            return view('admin.hotel.view',$data);
        }
        catch(\Exception $ex){
            return redirect()->back()->with('error', $ex->getMessage() . ' '. $ex->getLine() . ' '. $ex->getFile()); 
        }
    }

}
