<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use App\Models\Destination;

class DestinationsTableSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run()
    {
        $destinationArr = [
            array(
                'id'=>1,
                'name' => 'Hydrabad',
                'status'=> '1',
            ),
        ];


        // Insert data into the category table if the title does not exist
        foreach ($destinationArr as $des) {
            $existingDestination = DB::table('destinations')->where('name', $des['name'])->first();

            if (!$existingDestination) {
                DB::table('destinations')->insert($des);
            }
        }
    }
}
