<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        if (!Schema::hasTable('hotel_rules')) {
        Schema::create('hotel_rules', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('hotel_id')->default(0);
            $table->unsignedBigInteger('rules_id')->default(0);
            $table->timestamps();
            
            // Adding indexes
            $table->index('hotel_id');
            $table->index('rules_id');
            
            // Foreign key constraints
            $table->foreign('hotel_id')->references('id')->on('hotels')->onDelete('cascade');
            $table->foreign('rules_id')->references('id')->on('rules')->onDelete('cascade');
        });
    }
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('hotel_rules');
    }
};
