<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        if (!Schema::hasTable('bookings')) {
            Schema::create('bookings', function (Blueprint $table) {
                $table->id();
                $table->unsignedBigInteger('user_id')->default(0);
                $table->unsignedBigInteger('hotel_id')->default(0);
                $table->integer('room')->default(1); // Added 'room' field
                $table->integer('guest')->default(1); // Added 'guest' field
                $table->string('start_date', 16)->nullable();
                $table->string('end_date', 16)->nullable();
                $table->integer('price')->nullable();
                $table->enum('status', [1, 0])->default(1);
                $table->timestamps();
                $table->softDeletes();
                
                // Adding indexes
                $table->index('start_date');
                $table->index('end_date');
                $table->index('price');
                
                // Foreign key constraints
                $table->foreign('user_id')->references('id')->on('users')->onDelete('cascade');
                $table->foreign('hotel_id')->references('id')->on('hotels')->onDelete('cascade');
            });
        }
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('bookings');
    }
};
