<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        if (!Schema::hasTable('coupon_hotels')) {
            Schema::create('coupon_hotels', function (Blueprint $table) {
                $table->id();
                $table->unsignedBigInteger('coupon_id')->default(0);
                $table->unsignedBigInteger('hotel_id')->default(0);
                $table->timestamps();

                // Foreign key constraints
                $table->foreign('coupon_id')->references('id')->on('coupons')->onDelete('cascade');
                $table->foreign('hotel_id')->references('id')->on('hotels')->onDelete('cascade');
            });
        }
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('coupon_hotels');
    }
};
