<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        if (!Schema::hasTable('hotels')) {
            Schema::create('hotels', function (Blueprint $table) {
                $table->id();
                $table->unsignedBigInteger('destination_id')->default(0);
                $table->unsignedBigInteger('category_id')->default(0);
                $table->string('name', 100)->nullable();
                $table->string('phone', 14)->nullable();
                $table->text('front_image')->nullable();
                $table->string('guest', 50)->nullable();
                $table->integer('price')->nullable();
                $table->enum('type', ['Day', 'Night'])->default('Night');
                $table->integer('service_charge')->nullable();
                $table->integer('tax_fees')->nullable();
                $table->string('room', 50)->nullable();
                $table->text('address')->nullable();
                $table->string('latitude', 30)->nullable();
                $table->string('longitude', 30)->nullable();
                $table->string('license_document', 50)->nullable();
                $table->text('description')->nullable();
                $table->enum('status',[1,0])->default(1);
                $table->enum('is_recommended', ['Yes', 'No'])->default('No');
                $table->timestamps();
                $table->softDeletes();
                
                // Foreign key constraints
                $table->foreign('destination_id')->references('id')->on('destinations')->onDelete('cascade');
                $table->foreign('category_id')->references('id')->on('categories')->onDelete('cascade');

                // Adding indexes
                $table->index('name');
                $table->index('address');
                $table->index('created_at');
                $table->index('updated_at');
            });
        }
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('hotels');
    }
};
