<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Symfony\Component\HttpFoundation\Response;

class AuthenticateVendorApi
{
    /**
     * Handle an incoming request.
     *
     * @param  \Closure(\Illuminate\Http\Request): (\Symfony\Component\HttpFoundation\Response)  $next
     */
    public function handle(Request $request, Closure $next): Response
            {
                
                if ($request->is('api/*')) { 
                    $token = $request->header('Authorization');
                    if ($token == null) {
                        return redirect()->route('authentication-failed');
                    } else {
                        $tokenData = \Helpers::validateVendorAuthToken($token);
                        if (!$tokenData) {
                            return redirect()->route('authentication-failed');
                        } else {
                            $request->merge(['vendor' => $tokenData]);
                            return $next($request);
                        }
                    }
                } else if ($request->is('/*') || $request->is('/*')) {
                    return redirect('vendor/login');
                } else {
                    return redirect('vendor/login');
                }
            }
}
