<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Coupon;
use App\Models\Hotel;
use App\Models\User;
use App\Models\CouponCustomer;
use App\Models\CouponRestaurant;
use Illuminate\Support\Facades\Validator;
use Session;

class CouponController extends Controller
{
    /**
     * Display a listing.
     * @param \Illuminate\Http\Request $request
     * @return \Illuminate\Http\Response
    **/
    public function index(Request $request)
    {

        try{
            $data['hotelData'] = Hotel::get();
            $data['statusTypes'] = \Helpers::getStatusType();
            $data['discountTypes'] = \Helpers::getDiscountType();
            $data['result'] = Coupon::getLists($request->all());

            return view('admin.coupon.list',$data);
        }
        catch(\Exception $ex){
            return redirect()->back()->with('error', $ex->getMessage() . ' '. $ex->getLine() . ' '. $ex->getFile()); 
        }
    }


    /**
     * Display a page.
     * @param \Illuminate\Http\Request $request
     * @return \Illuminate\Http\Response
    **/
    public function create(Request $request)
    { 
        $data['hotelData'] = Hotel::where('status',1)->get();
        $data['customerData'] = User::where('status', 1)
                            ->whereNotNull('name')
                            ->where('type','user')
                            ->where('name', '!=', '')
                            ->get();
        $data['discountTypes'] = \Helpers::getDiscountType();
        $data['couponTypes'] = \Helpers::getCouponTypes();
        return view('admin.coupon.create',$data);
    }


    /**
     * Store a newly created resource.
     *
     * @param  \App\Http\Requests\Store  $request
     * @return \Illuminate\Http\Response
    **/

    public function store(Request $request)
    {
        dd($request->all());
        try{
            $rules = [
                'title' => 'required|string|max:255',
                'code' => 'required|string|max:255|unique:coupons',
                'discount_type' => 'required',
                'hotel_id' => 'required|array',
                'hotel_id.*' => 'exists:hotels,id',
                'customer_id' => 'required|array',
                'customer_id.*' => 'exists:users,id',
                'limit_for_same_user' => 'required|numeric|min:0',
                'start_date' => 'nullable|date',
                'expire_date' => 'nullable|date|after_or_equal:start_date',
                'coupon_type' => 'required',
                'discount' => 'required|numeric|min:0',
                'max_discount' => 'required|numeric|min:0',
            ];

            // Validation messages
            $messages = [
                'hotel_id.*.exists' => 'One or more selected hotel do not exist.',
                'customer_id.*.exists' => 'One or more selected customers do not exist.',
            ];

            // Validate the request
            $validator = Validator::make($request->all(), $rules, $messages);

            // Check if the validation fails
            if ($validator->fails()) {
                return redirect()->back()->withErrors($validator)->withInput();
            }

            $added = Coupon::addUpdate($request->all());
            if($added['status']==true){
                Session::flash('success', $added['message']);
                return redirect('admin/coupon')->with('success', $added['message']); 
            }
            else{
                return redirect()->back()->with('error', $added['message']);
            }
        }
        catch(\Exception $ex){
            return redirect()->back()->with('error', $ex->getMessage() . ' '. $ex->getLine() . ' '. $ex->getFile()); 
        }
    }


    /**
     * Display a edit listing.
     * @param \Illuminate\Http\Request $request
     * @return \Illuminate\Http\Response
    **/
    public function edit(Request $request,$id)
    {
        try{
            $data['result'] = Coupon::where('id',$id)->first();
            $data['hotelData'] = Hotel::where('status',1)->get();
            $data['customerData'] = User::where('status',1)->where('name', '!=', '')->where('type','user')->get();
            $data['discountTypes'] = \Helpers::getDiscountType();
            $data['couponTypes'] = \Helpers::getCouponTypes();
            return view('admin.coupon.edit',$data);
        }
        catch(\Exception $ex){
            return redirect()->back()->with('error', $ex->getMessage() . ' '. $ex->getLine() . ' '. $ex->getFile()); 
        }
    }

    /**
     * Update the specified in storage.
     *
     * @param  \App\Http\Requests\UpdateRequest  $request
     * @param  id  $id
     * @return \Illuminate\Http\Response
    **/
    public function update(Request $request)
    {
        try{
            $updated = Coupon::addUpdate($request->all(),$request->input('id'));
            if($updated['status']==true){
                return redirect('admin/coupon')->with('success', $updated['message']); 
            }
            else{
                return redirect()->back()->with('error', $updated['message']);
            } 
        }
        catch(\Exception $ex){
            return redirect()->back()->with('error', $ex->getMessage() . ' '. $ex->getLine() . ' '. $ex->getFile()); 
        }
    }

    /**
     * Remove the specified from storage.
     *
     * @param  id  $id
     * @return \Illuminate\Http\Response
    **/
    public function destroy($id)
    {
        try{
            $deleted = Coupon::deleteRecord($id);
            
            if($deleted['status']==true){
                return redirect()->back()->with('success', $deleted['message']); 
            }
            else{
                return redirect()->back()->with('error', $deleted['message']);
            } 
        }
        catch(\Exception $ex){
            return redirect()->back()->with('error', $ex->getMessage() . ' '. $ex->getLine() . ' '. $ex->getFile()); 
        }
    }
    /**
     * Remove the specified Subcategory from storage.
     *
     * @param  id  $id
     * @return \Illuminate\Http\Response
    **/
    public function updateColumn($id)
    {
        try{
            $updated = Coupon::updateColumn($id);
            if($updated['status']==true){
                return redirect()->back()->with('success', $updated['message']); 
            }
            else{
                return redirect()->back()->with('error', $updated['message']);
            } 
        }
        catch(\Exception $ex){
            return redirect()->back()->with('error', $ex->getMessage() . ' '. $ex->getLine() . ' '. $ex->getFile()); 
        }
    }
}
