<?php

namespace App\Http\Controllers\API\Vendor;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Str;
use Auth;
use DB;
use Validator;
use Carbon\Carbon;
use Illuminate\Support\Facades\Cache;
use Symfony\Component\HttpFoundation\Response;
use App\Models\User;
use App\Models\Coupon;
use App\Models\Hotel;
use App\Models\Additional_Info;
use App\Models\Cancellation_Policy;
use App\Models\Specification;
use App\Models\Hotel_Off_Days;
use App\Models\Hotel_Images;
use App\Models\HotelFeature;
use App\Models\Hotel_Rules;
use App\Models\Hotel_Aminities;


class VendorHotelAPIController extends Controller
{
    private $language;
    public function __construct()
    {
        // No need to call parent::__construct() here
        $this->language = request()->header('language-code') && request()->header('language-code') != '' ? request()->header('language-code') : 'en';
    }
    
    /**
     * Do Save Hotel
     *
     * @param \Illuminate\Http\Request $request
     * @return \Illuminate\Http\Response
     */
    public function doSaveHotel(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'destination_id' => 'required|exists:destinations,id',
            'name' => 'required|string|max:255',
            'address' => 'required|string|max:255',
            'latitude' => 'required|numeric',
            'longitude' => 'required|numeric',
            'street' => 'required|string|max:255',
            'area' => 'required|string|max:255',
            'city' => 'required|string|max:255',
            'pincode' => 'required|digits:6',
            'state' => 'required|string|max:255',
            'max_guest' => 'required|integer|min:1',
            'rooms' => 'required|integer|min:1',
            'bedrooms' => 'required|integer|min:1',
            'beds' => 'required|integer|min:1',
            'bathrooms' => 'required|integer|min:1',
            'smoking' => 'required|in:Allowed,Not-Allowed',
            'pets' => 'required|in:Allowed,Not-Allowed',
            'parties_events' => 'required|in:Allowed,Not-Allowed',
            'front_image' => 'required',
            'images' => 'required|array',
            'img_description' => 'string|max:2000',
            'rules_id' => 'required|array',
            'price' => 'required|numeric|min:0',
            'minimum_price' => 'required|numeric|min:0',
            'maximum_price' => 'required|numeric|min:0',
            'type' => 'required|in:Day,Night,Day-Night',
            'service_charge' => 'required|numeric|min:0',
            'tax_fees' => 'required|numeric|min:0',
            'description' => 'required',
            'is_recommended' => 'required|in:Yes,No',
            'additional_title' => 'required|array',
            'specification_title' => 'required|array',
            'amenities_id' => 'required|array',
            'rules_id' => 'required|array',
            'availability_dates' => 'required|array',
            'availability_dates.*' => 'date_format:Y/m/d',
        ]);
    
        if ($validator->fails()) {
            return $this->sendError(__('lang.message_required_message'), $validator->errors());
        }
    
        DB::beginTransaction();
        try {
            if($request->vendor){
            // Prepare data arrays
            $amenities_id_arr = $request->amenities_id ?? [];
            $additional_title_arr = $request->additional_title ?? [];
            $specification_title_arr = $request->specification_title ?? [];
            $images_arr = $request->images ?? [];
            $rules_id_arr = $request->rules_id ?? [];
            $off_days_arr = $request->availability_dates ?? [];
    
            // Create hotel data array
            $hotelData = [
                'add_type' => 'Vendor',
                'vendor_id' => $request->vendor->id,
                'destination_id' => $request->destination_id,
                'name' => $request->name,
                'address' => $request->address,
                'latitude' => $request->latitude,
                'longitude' => $request->longitude,
                'street' => $request->street,
                'area' => $request->area,
                'city' => $request->city,
                'pincode' => $request->pincode,
                'state' => $request->state,
                'profile_name' => $request->profile_name,
                'phone' => $request->phone,
                'max_guest' => $request->max_guest,
                'room' => $request->rooms,
                'bedrooms' => $request->bedrooms,
                'beds' => $request->beds,
                'bathrooms' => $request->bathrooms,
                'smoking' => $request->smoking,
                'pets' => $request->pets,
                'parties_events' => $request->parties_events,
                'price' => $request->price,
                'minimum_price' => $request->minimum_price,
                'maximum_price' => $request->maximum_price,
                'type' => $request->type,
                'service_charge' => $request->service_charge,
                'tax_fees' => $request->tax_fees,
                'is_recommended' => $request->is_recommended,
                'description' => $request->description,
                'created_at' => date('Y-m-d H:i:s'),
            ];
    
            // Handle front image upload
            if (isset($request->front_image) && $request->front_image != '') {
                $uploadImage = \Helpers::uploadFiles($request->front_image, 'hotel/front_image');
                if ($uploadImage['status'] === true) {
                    $hotelData['front_image'] = $uploadImage['file_name'];
                }
            }
            
            // Handle Profile image upload
            if (isset($request->profile_pic) && $request->profile_pic != '') {
                $uploadProfilePic = \Helpers::uploadFiles($request->profile_pic, 'hotel/profile_pic');
                if ($uploadProfilePic['status'] === true) {
                    $hotelData['profile_pic'] = $uploadProfilePic['file_name'];
                }
            }
    
            // Handle license document upload
            if (isset($request->license_document) && $request->license_document != '') {
                $uploadImage = \Helpers::uploadFiles($request->license_document, 'hotel/license_documents');
                if ($uploadImage['status'] === true) {
                    $hotelData['license_document'] = $uploadImage['file_name'];
                }
            }
    
            // Insert hotel data
            $hotel_id = Hotel::insertGetId($hotelData);
    
            // Insert additional information
            if(isset($additional_title_arr) && $additional_title_arr!=''){
            foreach ($additional_title_arr as $title) {
                $data = array(
                    'hotel_id'=> $hotel_id,
                    'title' => $title
                );
                Additional_Info::create($data);
            }
            }
            
            // Handle amenities
            if(isset($amenities_id_arr) && $amenities_id_arr!=''){
                foreach ($amenities_id_arr as $key => $value) {
                    $data = array(
                        'hotel_id'=> $hotel_id,
                        'aminities_id' => $value
                    );
                    Hotel_Aminities::create($data);
                }
            }
    
            // Insert specifications
            if(isset($specification_title_arr) && $specification_title_arr!=''){
            foreach ($specification_title_arr as $title) {
                Specification::create([
                    'hotel_id' => $hotel_id,
                    'title' => $title
                ]);
            }
            }
    
            // Insert off days
            if(isset($off_days_arr) && $off_days_arr!=''){
            foreach ($off_days_arr as $offDay) {
                Hotel_Off_Days::create([
                    'hotel_id' => $hotel_id,
                    'off_days' => $offDay
                ]);
            }
            }
    
            // Handle image uploads
            if(isset($images_arr) && $images_arr!=''){
            foreach ($images_arr as $image) {
                \Log::info('Uploading image: ', ['image' => $image->getClientOriginalName()]);
    
                $uploadImage = \Helpers::multipleUploadFiles($image, 'hotel/images');
                if ($uploadImage['status'] === true) {
                    Hotel_Images::create([
                        'hotel_id' => $hotel_id,
                        'images' => $uploadImage['file_name']
                    ]);
                } else {
                    \Log::error('Image upload failed: ', ['error' => $uploadImage['message']]);
                }
            }
            }

            // Insert rules
            if(isset($rules_id_arr) && $rules_id_arr!=''){
            foreach ($rules_id_arr as $rules_id) {
                Hotel_Rules::create([
                    'hotel_id' => $hotel_id,
                    'rules_id' => $rules_id
                ]);
            }
            }
    
            // Retrieve and return the newly created hotel
            $hotel = Hotel::with('additionalInfos','destination','offdays','specification','hotelAminities','hotelRules','hotelImages','aminities')->find($hotel_id);
            DB::commit();
            return $this->sendResponse($hotel, __('lang.message_data_retrived_successfully'));
            }else{
                return $this->sendResponse([], __('lang.vendor_not_found'));
            }
    
        } catch (\Exception $ex) {
            DB::rollBack();
            \Log::error('Error saving hotel: ', ['exception' => $ex]);
            return $this->sendError($ex->getMessage());
        }
    }
    
    /**
    * Fetch Details here
    **/
    public function vendorHotelListing(Request $request)
    {
        try {
            // Fetch hotels for the specified vendor with status 1
            $hotelData = Hotel::where('status', 1)
                ->with('destination')
                ->where('vendor_id', $request->vendor->id)
                ->get();
    
            // Check if the collection is empty
            if ($hotelData->isEmpty()) {
                return $this->sendError('Hotel not found');
            }
    
            // Format the response using the helper function
            $formattedHotelData = \Helpers::formatAllHotelData($hotelData);
    
            // Return the response with the relevant data
            return $this->sendResponse($formattedHotelData, __('lang.message_data_retrived_successfully'));
        } catch (\Exception $ex) {
            // Return error response in case of exception
            return $this->sendError($ex->getMessage());
        }
    }
    
    /**
    * Fetch Details here
    **/
    public function EditHotel(Request $request)
    {
        try {
            $validator = Validator::make($request->all(), [
            'hotelId' => 'required|exists:hotels,id',
            ]);
            
            if ($validator->fails()) {
                return $this->sendError(__('lang.message_required_message'), $validator->errors());
            }
            // Fetch hotels for the specified vendor with status 1
            $hotelData = Hotel::where('id', $request->hotelId)
                ->with('destination')
               ->where('vendor_id', $request->vendor->id)
                ->first();
            // Check if the collection is empty  ->where('vendor_id', $request->vendor->id)
            if ($hotelData === null) {
                return $this->sendError('Hotel not found');
            }
    
            // Format the response using the helper function
            $formattedHotelData = \Helpers::formatHotelData($hotelData);
    
            // Return the response with the relevant data
            return $this->sendResponse($formattedHotelData, __('lang.message_data_retrived_successfully'));
        } catch (\Exception $ex) {
            // Return error response in case of exception
            return $this->sendError($ex->getMessage());
        }
    }
    
    
    /**
     * Do Update Hotel
     *
     * @param \Illuminate\Http\Request $request
     * @return \Illuminate\Http\Response
     */
    public function doUpdateHotel(Request $request)
    {
        DB::beginTransaction();
        try {
            if($request->vendor){
            $amenities_id_arr = $request->amenities_id ?? [];
            $additional_title_arr = $request->additional_title ?? [];
            $specification_title_arr = $request->specification_title ?? [];
            $images_arr = $request->images ?? [];
            $rules_id_arr = $request->rules_id ?? [];
            $off_days_arr = $request->availability_dates ?? [];
            
            if(isset($request->hotelId)){
                $hotel_id = $request->hotelId;
                if(!$hotel_id){
                    return $this->sendError('Hotel Id not found');
                }
            }
            $hotelData = array(
                'updated_at' => date("Y-m-d H:i:s")
            );
            // Create hotel data array
            if(isset($request->name)){
                    $hotelData['name'] = $request->name;
                }
            if(isset($request->destination_id)){
                    $hotelData['destination_id'] = $request->destination_id;
                }
            if(isset($request->name)){
                    $hotelData['name'] = $request->name;
                }
            if(isset($request->address)){
                    $hotelData['address'] = $request->address;
                }
            if(isset($request->latitude)){
                    $hotelData['latitude'] = $request->latitude;
            }
            if(isset($request->longitude)){
                    $hotelData['longitude'] = $request->longitude;
            }
            if(isset($request->street)){
                    $hotelData['street'] = $request->street;
            }
            if(isset($request->area)){
                    $hotelData['area'] = $request->area;
            }
            if(isset($request->city)){
                    $hotelData['city'] = $request->city;
            }
            if(isset($request->pincode)){
                    $hotelData['pincode'] = $request->pincode;
            }
            if(isset($request->state)){
                    $hotelData['state'] = $request->state;
            }
              if(isset($request->profile_name)){
                    $hotelData['profile_name'] = $request->profile_name;
            }
              if(isset($request->phone)){
                    $hotelData['phone'] = $request->phone;
            }
            if(isset($request->max_guest)){
                    $hotelData['max_guest'] = $request->max_guest;
            }
            if(isset($request->rooms)){
                    $hotelData['room'] = $request->rooms;
            }
            if(isset($request->bedrooms)){
                    $hotelData['bedrooms'] = $request->bedrooms;
            }
            if(isset($request->beds)){
                    $hotelData['beds'] = $request->beds;
            }
            if(isset($request->bathrooms)){
                    $hotelData['bathrooms'] = $request->bathrooms;
            }
            if(isset($request->smoking)){
                    $hotelData['smoking'] = $request->smoking;
            }
            if(isset($request->pets)){
                    $hotelData['pets'] = $request->pets;
            }
            if(isset($request->parties_events)){
                    $hotelData['parties_events'] = $request->parties_events;
            }
            if(isset($request->price)){
                    $hotelData['price'] = $request->price;
            }
            if(isset($request->minimum_price)){
                    $hotelData['minimum_price'] = $request->minimum_price;
            }
            if(isset($request->maximum_price)){
                    $hotelData['maximum_price'] = $request->maximum_price;
            }
            if(isset($request->type)){
                    $hotelData['type'] = $request->type;
            }
            if(isset($request->service_charge)){
                    $hotelData['service_charge'] = $request->service_charge;
            }
            if(isset($request->tax_fees)){
                    $hotelData['tax_fees'] = $request->tax_fees;
            }
            if(isset($request->is_recommended)){
                    $hotelData['is_recommended'] = $request->is_recommended;
            }
            if(isset($request->description)){
                    $hotelData['description'] = $request->description;
            }
    
            // Handle front image upload
            if(isset($request->front_image)){
                if (isset($request->front_image) && $request->front_image != '') {
                    $uploadImage = \Helpers::uploadFiles($request->front_image, 'hotel/front_image');
                    if ($uploadImage['status'] === true) {
                        $hotelData['front_image'] = $uploadImage['file_name'];
                    }
                }
            }
            
             // Handle front image upload
            if(isset($request->profile_pic)){
                if (isset($request->profile_pic) && $request->profile_pic != '') {
                    $uploadProfilePic = \Helpers::uploadFiles($request->profile_pic, 'hotel/profile_pic');
                    if ($uploadProfilePic['status'] === true) {
                        $hotelData['profile_pic'] = $uploadProfilePic['file_name'];
                    }
                }
            }
    
            // Handle license document upload
            if(isset($request->license_document)){
                if (isset($request->license_document) && $request->license_document != '') {
                    $uploadImage = \Helpers::uploadFiles($request->license_document, 'hotel/license_documents');
                    if ($uploadImage['status'] === true) {
                        $hotelData['license_document'] = $uploadImage['file_name'];
                    }
                }
            }
    
            // Insert hotel data
            $hotel_id = Hotel::where('id',$hotel_id)->update($hotelData);
            // Insert additional information
            if(isset($additional_title_arr) && $additional_title_arr!=''){
            Additional_Info::where('hotel_id',$hotel_id)->delete();
            foreach ($additional_title_arr as $title) {
                $data = array(
                    'hotel_id'=> $hotel_id,
                    'title' => $title
                );
                Additional_Info::create($data);
            }
            }
            
            // Handle amenities
            if(isset($amenities_id_arr) && $amenities_id_arr!=''){
                Hotel_Aminities::where('hotel_id',$hotel_id)->delete();
                foreach ($amenities_id_arr as $key => $value) {
                    $data = array(
                        'hotel_id'=> $hotel_id,
                        'aminities_id' => $value
                    );
                    Hotel_Aminities::create($data);
                }
            }
    
            // Insert specifications
            if(isset($specification_title_arr) && $specification_title_arr!=''){
                Specification::where('hotel_id',$hotel_id)->delete();
                foreach ($specification_title_arr as $title) {
                    Specification::create([
                        'hotel_id' => $hotel_id,
                        'title' => $title
                    ]);
                }
            }
    
            // Insert off days
            if(isset($off_days_arr) && $off_days_arr!=''){
                Hotel_Off_Days::where('hotel_id',$hotel_id)->delete();
                foreach ($off_days_arr as $offDay) {
                    Hotel_Off_Days::create([
                        'hotel_id' => $hotel_id,
                        'off_days' => $offDay
                    ]);
                }
            }
    
            // Handle image uploads
            if(isset($images_arr) && $images_arr!=''){
                Hotel_Images::where('hotel_id',$hotel_id)->delete();
                foreach ($images_arr as $image) {
                    \Log::info('Uploading image: ', ['image' => $image->getClientOriginalName()]);
        
                    $uploadImage = \Helpers::multipleUploadFiles($image, 'hotel/images');
                    if ($uploadImage['status'] === true) {
                        Hotel_Images::create([
                            'hotel_id' => $hotel_id,
                            'images' => $uploadImage['file_name']
                        ]);
                    } else {
                        \Log::error('Image upload failed: ', ['error' => $uploadImage['message']]);
                    }
                }
            }

            // Insert rules
            if(isset($rules_id_arr) && $rules_id_arr!=''){
                Hotel_Rules::where('hotel_id',$hotel_id)->delete();
                foreach ($rules_id_arr as $rules_id) {
                    Hotel_Rules::create([
                        'hotel_id' => $hotel_id,
                        'rules_id' => $rules_id
                    ]);
                }
            }
    
            $hotelData = Hotel::where('id', $request->hotelId)
                ->with('destination')
                ->where('vendor_id', $request->vendor->id)
                ->first();
            if ($hotelData === null) {
                return $this->sendError('Hotel not found');
            }
    
            // Format the response using the helper function
            $formattedHotelData = \Helpers::formatHotelData($hotelData);
            DB::commit();
            return $this->sendResponse($formattedHotelData, __('lang.admin_data_update_msg'));
            }else{
                return $this->sendResponse([], __('lang.vendor_not_found'));
            }
    
        } catch (\Exception $ex) {
            DB::rollBack();
            \Log::error('Error saving hotel: ', ['exception' => $ex]);
            return $this->sendError($ex->getMessage());
        }
    }
    
    /**
     * Delete a hotel
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function deleteHotel(Request $request)
    {
        try {
            $validator = Validator::make($request->all(), [
                'hotelId' => 'required|exists:hotels,id',
            ]);
            
            if ($validator->fails()) {
                return $this->sendError(__('lang.message_required_message'), $validator->errors());
            }
    
            // Delete the hotel for the specified vendor
            $deleted = Hotel::where('id', $request->hotelId)
                ->where('vendor_id', $request->vendor->id)
                ->delete();
                
            if (!$deleted) {
                return $this->sendError('Hotel not found');
            }
    
            return $this->sendResponse(null, __('lang.message_data_deleted_successfully'));
        } catch (\Exception $ex) {
            // Return error response in case of exception
            return $this->sendError($ex->getMessage());
        }
    }

    
}
