<?php

namespace App\Http\Controllers\API;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Str;
use Auth;
use DB;
use Validator;
use Carbon\Carbon;
use Illuminate\Support\Facades\Cache;
use Symfony\Component\HttpFoundation\Response;
use App\Models\User;
use App\Models\Hotel;
use App\Models\Rating;

class RatingAPIController extends Controller
{
    private $language;
    public function __construct()
    {
        // No need to call parent::__construct() here
        $this->language = request()->header('language-code') && request()->header('language-code') != '' ? request()->header('language-code') : 'en';
    }
    
    
    /**
     *  Do Save Rating
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function doSaveRating(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'hotel_id' => 'required|exists:hotels,id',
            'rating' => 'required',
            'comment' => 'required',
        ]);
        if ($validator->fails()) {
            return $this->sendError(__('lang.message_required_message'), $validator->errors());
        }
        DB::beginTransaction();
        try {
            $rating = Rating::create([
                'user_id' => $request->user->id,
                'hotel_id' => $request->hotel_id,
                'rating' => $request->rating,
                'comment' => $request->comment,
            ]);

            DB::commit();

            $ratingData = Rating::with('user:id,name', 'hotel:id,name')->find($rating->id);
            return $this->sendResponse($ratingData, __('lang.message_data_retrived_successfully'));
        } catch (\Exception $ex) {
            DB::rollBack();
            return $this->sendError($ex->getMessage());
        }
    }

    /**
     *  Get View Rating
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function getViewRating(Request $request)
    {
        try {
            $pagination_no = config('constant.api_pagination');
            if (isset($request->per_page) && !empty($request->per_page)) {
                $pagination_no = $request->per_page;
            }

            $resData = Rating::with(['user','hotel'])->where('hotel_id',$request->hotelId)->where('status', 1)->get();
            return $this->sendResponse($resData, __('lang.message_data_retrived_successfully'));
        } catch (\Exception $ex) {
            return $this->sendError($ex->getMessage());
        }
    }
    
}