<div class="card">
<div class="card-header">
    <div class="row">
        <div class="col-md-6">
            <h5><?php echo e(__('lang.admin_coupon_list')); ?></h5>
        </div>
        <div class="col-md-6">
            <h6 class="float-right">
                <?php if ($result->firstItem() != null) {?>
                <?php echo e(__('lang.admin_showing')); ?> <?php echo e($result->firstItem()); ?>-<?php echo e($result->lastItem()); ?>

                <?php echo e(__('lang.admin_of')); ?> <?php echo e($result->total()); ?> <?php }?>
            </h6>
        </div>
    </div>
</div>
<div class="card-body">
    <div class="table-responsive text-nowrap">
        <table class="table">
            <thead class="table-light">
                <tr class="text-nowrap">
                    <th><?php echo e(__('lang.admin_id')); ?></th>
                    <th><?php echo e(__('lang.admin_title')); ?></th>
                    <th><?php echo e(__('lang.admin_code')); ?></th>
                    <th><?php echo e(__('lang.admin_type')); ?></th>
                    <th><?php echo e(__('lang.admin_total_users')); ?></th>
                    <th><?php echo e(__('lang.admin_max_discount')); ?></th>
                    <th><?php echo e(__('lang.admin_discount')); ?></th>
                    <th><?php echo e(__('lang.admin_discount_type')); ?></th>
                    <th><?php echo e(__('lang.admin_start_date')); ?></th>
                    <th><?php echo e(__('lang.admin_expire_date')); ?></th>
                    <th><?php echo e(__('lang.admin_status')); ?></th>
                    <th><?php echo e(__('lang.admin_action')); ?></th>
                </tr>
            </thead>
            <tbody>
                <?php if(count($result) > 0): ?>
                <?php $__currentLoopData = $result; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $row): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <tr>
                    <td><?php echo e($row->id); ?></td>
                    <td><?php echo e($row->title); ?></td>
                    <td><?php echo e($row->code); ?></td>
                    <td><?php echo e($row->coupon_type); ?></td>
                    <td>
                        <?php if($row->customers != ''): ?>
                            <?php echo e(count($row->customers)); ?>

                        <?php else: ?>
                            0
                        <?php endif; ?>
                    </td>
                    <td><?php echo e(\Helpers::commonPriceFormate($row->max_discount)); ?></td>
                    <td><?php echo e($row->discount); ?></td>
                    <td><?php echo e($row->discount_type); ?></td>
                    <td><?php echo e(\Helpers::commonDateFormate($row->start_date)); ?></td>
                    <td><?php echo e(\Helpers::commonDateFormate($row->expire_date)); ?></td>
                    <td>
                        <?php if($row->status == 1): ?>
                        <a href="<?php echo e(url('admin/update-coupon-column/'.$row->id)); ?>">
                            <span class="badge bg-success"><?php echo e(__('lang.admin_active')); ?></span></a>
                        <?php else: ?>
                        <a href="<?php echo e(url('admin/update-coupon-column/'.$row->id)); ?>">
                            <span class="badge bg-warning"><?php echo e(__('lang.admin_deactive')); ?></span></a>
                        <?php endif; ?>
                    </td>
                    <td>
                        <div class="inline_action_btn">
                            <a class="edit_icon" href="<?php echo e(url('admin/edit-coupon/'.$row->id)); ?>" title="<?php echo e(__('lang.admin_edit')); ?>"><i class="ti ti-pencil me-1"></i>
                            </a>
                            <a class="delete_icon" title="<?php echo e(__('lang.admin_delete')); ?>" href="javascript:void(0);" onclick="showDeleteConfirmation('coupon' , <?php echo e($row->id); ?>)">
                                <i class="ti ti-trash me-1"></i>
                            </a>
                        </div>
                    </td>
                </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                <?php else: ?>
                <tr>
                    <td colspan="10" class="record-not-found">
                        <span><?php echo e(__('lang.admin_no_data_found')); ?></span>
                    </td>
                </tr>
                <?php endif; ?>
            </tbody>
        </table>
    </div>
</div>
<div class="card-footer">
    <div class="pagination" style="float: right;">
        <?php echo e($result->withQueryString()->links('pagination::bootstrap-4')); ?>

    </div>
</div>
</div><?php /**PATH /home/gyaanplant/mystaycation.gyaanplant.com/resources/views/admin/coupon/table.blade.php ENDPATH**/ ?>