<div class="card">
<div class="card-header">
    <div class="row">
        <div class="col-md-6">
            <h5><?php echo e(__('lang.admin_booking_list')); ?></h5>
        </div>
        <div class="col-md-6">
            <h6 class="float-right">
                <?php if ($result->firstItem() != null) {?>
                <?php echo e(__('lang.admin_showing')); ?> <?php echo e($result->firstItem()); ?>-<?php echo e($result->lastItem()); ?>

                <?php echo e(__('lang.admin_of')); ?> <?php echo e($result->total()); ?> <?php }?>
            </h6>
        </div>
    </div>
</div>
<div class="card-body">
    <div class="table-responsive text-nowrap">
        <table class="table">
            <thead class="table-light">
                <tr class="text-nowrap">
                    <th><?php echo e(__('lang.admin_id')); ?></th>
                    <th><?php echo e(__('lang.admin_user_name')); ?></th>
                    <th><?php echo e(__('lang.admin_hotel_name')); ?></th>
                    <th><?php echo e(__('lang.admin_hotel_price')); ?></th>
                    <th><?php echo e(__('lang.admin_hotel_room')); ?></th>
                    <th><?php echo e(__('lang.admin_hotel_guest')); ?></th>
                    <th><?php echo e(__('lang.admin_start_date')); ?></th>
                    <th><?php echo e(__('lang.admin_end_date')); ?></th>
                    <th><?php echo e(__('lang.admin_created_at')); ?></th>
                    <th><?php echo e(__('lang.admin_status')); ?></th>
                    <th><?php echo e(__('lang.admin_action')); ?></th>
                </tr>
            </thead>
            <tbody>
                <?php if(count($result) > 0): ?>
                <?php $__currentLoopData = $result; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $row): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <tr>
                    <td><?php echo e($row->id); ?></td>
                    <td><?php echo e(\Helpers::checkNull($row->user->name)); ?></td>
                    <td><?php echo e(\Helpers::checkNull(@$row->hotel->name)); ?></td>
                    <td><?php echo e(\Helpers::checkNull($row->price)); ?></td>
                    <td><?php echo e(\Helpers::checkNull($row->room)); ?></td>
                    <td><?php echo e(\Helpers::checkNull($row->guest)); ?></td>
                    <td><?php echo e(\Helpers::commonDateFormate($row->start_date)); ?></td>
                    <td><?php echo e(\Helpers::commonDateFormate($row->end_date)); ?></td>
                    <td><?php echo e(\Helpers::commonDateFormate($row->created_at)); ?></td>
                    <td>
                        <?php if($row->status == 1): ?>
                        <a href="<?php echo e(url('admin/update-booking-column/'.$row->id)); ?>">
                            <span class="badge bg-success"><?php echo e(__('lang.admin_active')); ?></span></a>
                        <?php else: ?>
                        <a href="<?php echo e(url('admin/update-booking-column/'.$row->id)); ?>">
                            <span class="badge bg-warning"><?php echo e(__('lang.admin_deactive')); ?></span></a>
                        <?php endif; ?>
                    </td>
                    <td>
                        <div class="inline_action_btn">
                                <a class="delete_icon" href="javascript:void(0);" title="<?php echo e(__('lang.admin_delete')); ?>"
                                    onclick="showDeleteConfirmation('bookings' , <?php echo e($row->id); ?>)"
                                    ><i class="ti ti-trash me-1"></i></a
                                >
                        </div>
                    </td>

                    <!-- Modal to edit new record -->
                    <div class="offcanvas offcanvas-end" id="edit-new-record_<?php echo e($row->id); ?>">
                        <div class="offcanvas-header border-bottom">
                            <h5 class="offcanvas-title"
                                id="exampleModalLabel"><?php echo e(__('lang.admin_edit_customer')); ?></h5>
                            <button type="button" class="btn-close text-reset"
                                data-bs-dismiss="offcanvas" aria-label="Close"></button>
                        </div>
                        <div class="offcanvas-body flex-grow-1">
                            <form action="<?php echo e(url('admin/update-customer')); ?>" method="POST"
                                enctype="multipart/form-data">
                                <?php echo csrf_field(); ?>
                                <input type="hidden" name="id" value="<?php echo e($row->id); ?>">

                                <div class="col-sm-12">
                                    <label class="form-label"
                                        for="name"><?php echo e(__('lang.admin_name')); ?> <span class="required">*</span></label>
                                    <div class="input-group input-group-merge">
                                        <input type="text" id="basicFullname"
                                            class="form-control dt-full-name" name="name"
                                            value="<?php echo e($row->name); ?>"
                                            placeholder="<?php echo e(__('lang.admin_name_placeholder')); ?>"
                                            aria-label="John Doe"
                                            aria-describedby="basicFullname2" required />
                                    </div>
                                </div>

                                <div class="col-sm-12 mt-3">
                                    <label class="form-label"
                                        for="name"><?php echo e(__('lang.admin_email')); ?> <span class="required">*</span></label>
                                    <div class="input-group input-group-merge">
                                        <input type="email" id="basicFullname"
                                            class="form-control dt-full-name" name="email"
                                            value="<?php echo e($row->email); ?>"
                                            placeholder="<?php echo e(__('lang.admin__email_placeholder')); ?>"
                                            aria-describedby="basicFullname2" required />
                                    </div>
                                </div>

                                <div class="col-sm-12 mt-3">
                                    <label class="form-label"
                                        for="name"><?php echo e(__('lang.admin_phone')); ?> <span class="required">*</span></label>
                                    <div class="input-group input-group-merge">
                                        <input type="tel" id="basicFullname"
                                            class="form-control dt-full-name" name="phone"
                                            value="<?php echo e($row->phone); ?>"
                                            placeholder="<?php echo e(__('lang.admin_phone_placeholder')); ?>"
                                            aria-describedby="basicFullname2" maxlength="10" required />
                                    </div>
                                </div>

                                <div class="col-sm-12 mt-3">
                                    <label class="form-label"
                                        for="name"><?php echo e(__('lang.admin_password')); ?> <span class="required">*</span></label>
                                    <div class="input-group input-group-merge">
                                        <input type="text" id="basicFullname"
                                            class="form-control dt-full-name" name="password"
                                            value="<?php echo e($row->password); ?>"
                                            placeholder="<?php echo e(__('lang.admin_password_placeholder')); ?>"
                                            aria-describedby="basicFullname2" required />
                                    </div>
                                </div>
                                
                                <div class="col-sm-12 mt-3">
                                    <button type="submit"
                                        class="btn btn-primary data-submit me-sm-3 me-1"><?php echo e(__('lang.admin_save_changes')); ?></button>
                                    <button type="reset" class="btn btn-outline-secondary"
                                        data-bs-dismiss="offcanvas"><?php echo e(__('lang.admin_cancel')); ?></button>
                                </div>
                            </form>
                        </div>
                    </div>
                    <!--/ Modal to add new record -->
                </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                <?php else: ?>
                <tr>
                    <td colspan="7" class="record-not-found">
                        <span><?php echo e(__('lang.admin_no_data_found')); ?></span>
                    </td>
                </tr>
                <?php endif; ?>
            </tbody>
        </table>
    </div>
</div>
<div class="card-footer">
    <div class="pagination" style="float: right;">
        <?php echo e($result->withQueryString()->links('pagination::bootstrap-4')); ?>

    </div>
</div>
</div><?php /**PATH /home/gyaanplant/mystaycation.gyaanplant.com/resources/views/admin/booking/table.blade.php ENDPATH**/ ?>