@extends('admin.layouts.app')
@section('content')

<!-- Content wrapper -->
<div class="content-wrapper">
    <!-- Content -->
    <div class="container-xxl flex-grow-1 container-p-y">


    <form action="{{url('admin/update-vendor-hotel')}}" method="POST" enctype="multipart/form-data">
        @csrf

        <div class="row">
            <div class="col-md-6">
                <h4 class="py-3 mb-4">
                  <span class="text-muted fw-light">
                    <a href="{{url('admin/dashboard')}}">{{__('lang.admin_dashboard')}}</a> /
                  </span><span class="text-muted fw-light">
                    <a href="{{url('admin/items')}}">{{__('lang.admin_hotel_list')}}</a> /
                  </span>
                  {{__('lang.admin_edit_hotel_form')}}</h4>
            </div>
            <div class="col-md-6">
                <div class="table-btn-css">
                    <button type="submit" class="btn btn-primary waves-effect waves-light">
                        <span class="ti-xs ti ti-plus me-1"></span>{{__('lang.admin_update')}}
                    </button>
                    <a type="reset" class="btn btn-outline-secondary" href="{{url('admin/hotel')}}">{{__('lang.admin_back')}}</a>
                </div>
            </div>
        </div>
        

        <!-- Hotel add -->
        <div class="row">
                  <!-- First column-->
                  <div class="col-12 col-lg-8">
                    <!-- Basic Information -->
                    <div class="card mb-4">
                      <div class="card-header">
                        <h5 class="card-tile mb-0">{{__('lang.admin_hotel_basic')}}</h5>
                      </div>
                      <div class="card-body row">
                          <!--id-->
                        <input type="hidden" name="id" value="{{$result->id}}">
                        <!-- Destination -->
                        <div class="mb-3 col-12 col ecommerce-select2-dropdown">
                          <label
                            class="form-label mb-1 d-flex justify-content-between align-items-center"
                            for="category-org">
                          <span>{{__('lang.admin_destination')}}</span><a href="{{url('admin/destination')}}" class="fw-medium">{{__('lang.admin_add_new_destination')}}</a>
                          </label>
                          <select class="select2 form-select" name="destination_id">
                                <option value="">{{__('lang.admin_select_destination')}}</option>
                                @if(count($destination_data))
                                     @foreach($destination_data as $destination)
                                           <option <?=$destination->id == $result->destination_id ? 'selected' : '';?> value="{{ $destination->id }}">{{ $destination->name }}</option>
                                        @endforeach
                              @endif
                             
                          </select>
                        </div>
                        
                        <!-- name -->
                        <div class="col-12">
                            <div class="mb-3">
                              <label class="form-label" for="ecommerce-product-name">{{__('lang.admin_name')}} <span class="required">*</span></label>
                              <input
                                type="text"
                                class="form-control"
                                id="ecommerce-product-name"
                                placeholder="{{__('lang.admin_name_placeholder')}}"
                                name="name"
                                aria-label="{{__('lang.admin_name')}}" required
                                value="{{ $result->name }}">
                            </div>
                        </div>
                         
                         <!--Profile Image -->
                        <div class="col-6">
                          <div class="mb-3">
                              <label class="form-label image_lable" for="ecommerce-category-image">{{__('lang.admin_profile_image')}} <span class="required">*</span></label>
                              <div class="avatar-upload">
                                  <div class="avatar-edit">
                                          <input type='file' id="imageUpload" accept=".png, .jpg, .jpeg" name="front_image">
                                          <label for="imageUpload"><i class="ti ti-pencil me-1 pencil_for_img_upload"></i></label>
                                      </div>
                                      <div class="avatar-preview">
                                          <div id="imagePreview" style='background-image: url("{{asset('/uploads/hotel/front_image/'.$result->front_image)}}");'>
                                          </div>
                                      </div>
                              </div>
                          </div>
                        </div>
                        
                         <!--Document Image -->
                        <div class="col-6">
                          <div class="mb-3">
                              <label class="form-label image_lable" for="ecommerce-category-image">{{__('lang.admin_licence_document')}} <span class="required">*</span></label>
                              <div class="avatar-upload">
                                  <div class="avatar-edit">
                                          <input type='file' id="imageUploadTwo" accept=".png, .jpg, .jpeg" name="license_document">
                                          <label for="imageUploadTwo"><i class="ti ti-pencil me-1 pencil_for_img_upload"></i></label>
                                      </div>
                                      <div class="avatar-preview">
                                          <div id="imagePreviewTwo" style='background-image: url("{{asset('/uploads/hotel/license_documents/'.$result->license_document)}}");'>
                                          </div>
                                      </div>
                              </div>
                          </div>
                        </div>
                        
                        <!-- Description -->
                        <div class="mb-3">
                            <label class="form-label" for="editor">{{__('lang.admin_description')}} <span class="required">*</span></label>
                            <textarea class="form-control" name="description" id="editor" placeholder="{{__('lang.admin_description_placeholder')}}" row="6">{!! $result->description !!}</textarea>
                        </div>


                      </div>
                    </div>
                    <!-- /Basic Information -->

                    <!-- Info -->
                    <div class="card mb-4">
                      <div class="card-header">
                        <h5 class="card-title mb-0">{{__('lang.admin_location_information')}}</h5>
                      </div>
                      <div class="card-body row">

                        <!-- address -->
                        <div class="mb-3">
                            <label class="form-label" for="short_description">{{__('lang.admin_address')}} <span class="required">*</span></label>
                            <textarea class="form-control" name="address" placeholder="{{__('lang.admin_address_placeholder')}}" row="6">{!! $result->address !!}</textarea>
                        </div>
                        
                        <!--latitude-->
                        <div class="mb-3">
                            <label class="form-label" for="ecommerce-product-name">{{__('lang.admin_latitude')}} <span class="required">*</span></label>
                            <input
                              type="text"
                              class="form-control"
                              id="latitude_id"
                              name="latitude"
                              aria-label="{{__('lang.admin_latitude')}}" 
                              value="17.4127332"
                              required
                              readonly
                              value="{{ $result->latitude }}"/>
                          </div>
                            
                        <!--longitude-->
                        <div class="mb-3">
                            <label class="form-label" for="ecommerce-product-name">{{__('lang.admin_longitude')}} <span class="required">*</span></label>
                            <input
                              type="text"
                              class="form-control"
                              id="longitude_id"
                              name="longitude"
                              aria-label="{{__('lang.admin_longitude')}}"
                              value="78.078363"
                              readonly
                              required
                              value="{{ $result->longitude }}"/>
                         </div>
                         
                        <!-- Street -->
                        <div class="mb-3 col-6">
                            <label class="form-label" for="ecommerce-product-name">{{__('lang.admin_street')}} <span class="required">*</span></label>
                            <input
                              type="text"
                              class="form-control"
                              id="street"
                              name="street"
                              aria-label="{{__('lang.admin_street')}}" 
                              value="{{$result->street}}"
                              required
                              readonly/>
                                </div>
                        <!--Area -->
                        <div class="mb-3 col-6">
                            <label class="form-label" for="ecommerce-product-name">{{__('lang.admin_area')}} <span class="required">*</span></label>
                            <input
                              type="text"
                              class="form-control"
                              id="area"
                              name="area"
                              aria-label="{{__('lang.admin_area')}}" 
                              value="{{$result->area}}"
                              required
                              readonly/>
                            </div>
                        <!--City -->
                        <div class="mb-3 col-4">
                            <label class="form-label" for="ecommerce-product-name">{{__('lang.admin_city')}} <span class="required">*</span></label>
                            <input
                              type="text"
                              class="form-control"
                              id="city"
                              name="city"
                              aria-label="{{__('lang.admin_city')}}" 
                              value="{{$result->city}}"
                              required
                              readonly/>
                                </div>
                        <!--Pincode -->
                        <div class="mb-3 col-4">
                            <label class="form-label" for="ecommerce-product-name">{{__('lang.admin_pincode')}} <span class="required">*</span></label>
                            <input
                              type="text"
                              class="form-control"
                              id="pincode"
                              name="pincode"
                              aria-label="{{__('lang.admin_pincode')}}" 
                              value="{{$result->pincode}}"
                              required
                              readonly/>
                                </div>
                        <!--State -->
                        <div class="mb-3 col-4">
                            <label class="form-label" for="ecommerce-product-name">{{__('lang.admin_state')}} <span class="required">*</span></label>
                            <input
                              type="text"
                              class="form-control"
                              id="state"
                              name="state"
                              aria-label="{{__('lang.admin_state')}}" 
                              value="{{$result->state}}"
                              required
                              readonly/>
                        </div>
                        

                      </div>
                    </div>
                    <!-- /Info -->
                    
                    <!--Avaibility Time-->
                    <div class="card mb-4">
                      <div class="card-header">
                        <h5 class="card-title mb-0">{{__('lang.admin_avaibility_information')}}</h5>
                      </div>
                      <div class="card-body row">
                        <!-- Check in -->
                        <div class="col-6">
                            <div class="mb-3">
                                <label class="form-label" for="check_in">{{__('lang.admin_check_in')}} <span class="required">*</span></label>
                                <input
                                type="time"
                                class="form-control"
                                id="check_in"
                                name="check_in"
                                aria-label="{{__('lang.admin_check_in')}}"
                                required
                                value="{{ $result->check_in }}">
                            </div>
                        </div>
                    
                        <!-- Check out -->
                        <div class="col-6">
                            <div class="mb-3">
                                <label class="form-label" for="check_out">{{__('lang.admin_check_out')}} <span class="required">*</span></label>
                                <input
                                    type="time"
                                    class="form-control"
                                    id="check_out"
                                    name="check_out"
                                    aria-label="{{__('lang.admin_check_out')}}"
                                    required
                                    value="{{ $result->check_out }}">
                            </div>
                        </div>
                    </div>

                    </div>
                    <!--Avaibility Time-->
                    
                                        <!-- Off days Data -->
                    <div class="card mb-4">
                      <div class="card-header">
                        <h5 class="card-title mb-0">{{__('lang.admin_off_days')}}</h5>
                      </div>
                      <div class="card-body row" id="off-days-container">
                        <!-- Initial input field -->
                        @if(isset($result->offdays) && $result->offdays->count())
                          @foreach($result->offdays as $index => $off_day)
                            <div class="col-10 mb-3">
                              <label class="form-label" for="off_days_{{$index}}">{{__('lang.admin_off_days')}} <span class="required">*</span></label>
                              <input type="date" class="form-control" id="off_days_{{$index}}" value="{{ $off_day->off_days }}" name="off_days[]" aria-label="{{__('lang.admin_off_days')}}">
                            </div>
                            <div class="col-2 mt-4">
                              <button type="button" class="btn btn-sm btn-danger" onclick="deleteInput(this, 'off_days')"><i class="ti ti-trash me-1"></i></button>
                              @if($index == $result->offdays->count() - 1)
                                <div class="col-2 mt-2 mb-2">
                                  <button type="button" class="btn btn-sm btn-info" onclick="appendData('off_days')"><i class="ti ti-plus me-1"></i></button>
                                </div>
                              @endif
                            </div>
                          @endforeach
                        @endif
                      </div>
                    </div>
                    <!-- /Off days Data -->



                    <!-- Additional Data -->
                    <div class="card mb-4">
                        <div class="card-header">
                            <h5 class="card-title mb-0">{{ __('lang.admin_additional_data') }}</h5>
                        </div>
                        <div class="card-body row" id="additional-points-container">
                            <!-- Existing additionalInfos data -->
                            @if(isset($result->additionalInfos) && $result->additionalInfos->count())
                                @foreach($result->additionalInfos as $index => $info)
                                    <div class="row additional-input">
                                        <div class="col-10 mb-3">
                                            <label class="form-label" for="ecommerce-product-name">{{ __('lang.admin_additional_point') }} <span class="required">*</span></label>
                                            <input type="text" class="form-control" name="additional_title[]" value="{{ $info->title }}" aria-label="{{ __('lang.admin_additional_placeholder') }}" placeholder="{{ __('lang.admin_additional_placeholder') }}">
                                        </div>
                                        <div class="col-2 mt-4">
                                            <button type="button" class="btn btn-sm btn-danger" onclick="deleteInput(this, 'additional')"><i class="ti ti-trash me-1"></i></button>
                                        @if($index == $result->additionalInfos->count() - 1)
                                        <div class="col-2 mt-2 mb-2">
                                        <button type="button" class="btn btn-sm btn-info" onclick="appendData('additional')"><i class="ti ti-plus me-1"></i></button>
                                        </div>
                                         @endif
                                        </div>
                                    </div>
                                @endforeach
                            @endif
                        </div>
                    </div>
                    <!-- /Additional Data -->

                    <!-- Cancellation Policy Data -->
                    <div class="card mb-4">
                      <div class="card-header">
                        <h5 class="card-title mb-0">{{ __('lang.admin_cancellation_policy') }}</h5>
                      </div>
                      <div class="card-body row" id="cancellation-points-container">
                        <!-- Existing cancellationPolicies data -->
                        @if(isset($result->cancellationPolicies) && $result->cancellationPolicies->count())
                          @foreach($result->cancellationPolicies as $index => $policy)
                            <div class="row cancellation-input">
                              <div class="col-10 mb-3">
                                <label class="form-label" for="ecommerce-product-name">{{ __('lang.admin_cancellation_point') }} <span class="required">*</span></label>
                                <input type="text" class="form-control" name="cancellation_policy_title[]" value="{{ $policy->title }}" aria-label="{{ __('lang.admin_cancellation_placeholder') }}" placeholder="{{ __('lang.admin_cancellation_placeholder') }}">
                              </div>
                              <div class="col-2 mt-4">
                                <button type="button" class="btn btn-sm btn-danger" onclick="deleteInput(this, 'cancellation')"><i class="ti ti-trash me-1"></i></button>
                              @if($index == $result->cancellationPolicies->count() - 1)
                                <div class="col-2 mt-2 mb-2">
                                <button type="button" class="btn btn-sm btn-info" onclick="appendData('cancellation_policy')"><i class="ti ti-plus me-1"></i></button>
                                </div>
                              @endif
                              </div>
                            </div>
                          @endforeach
                        @endif
                      </div>
                    </div>
                    <!-- /Cancellation Policy Data -->

                    
                    <!-- Specification Data -->
                    <div class="card mb-4">
                      <div class="card-header">
                        <h5 class="card-title mb-0">{{ __('lang.admin_specification_policy') }}</h5>
                      </div>
                      <div class="card-body row" id="specification-points-container">
                        <!-- Existing specification data -->
                        @if(isset($result->specification) && $result->specification->count())
                          @foreach($result->specification as $index => $spec)
                            <div class="row specification-input">
                              <div class="col-10 mb-3">
                                <label class="form-label" for="ecommerce-product-name">{{ __('lang.admin_specification_point') }} <span class="required">*</span></label>
                                <input type="text" class="form-control" name="specification_title[]" value="{{ $spec->title }}" aria-label="{{ __('lang.admin_specification_placeholder') }}" placeholder="{{ __('lang.admin_specification_placeholder') }}">
                              </div>
                              <div class="col-2 mt-4">
                                <button type="button" class="btn btn-sm btn-danger" onclick="deleteInput(this, 'specification')"><i class="ti ti-trash me-1"></i></button>
                              @if($index == $result->specification->count() - 1)
                                <div class="col-2 mt-2 mb-2">
                                <button type="button" class="btn btn-sm btn-info" onclick="appendData('specification')"><i class="ti ti-plus me-1"></i></button>
                                </div>
                              @endif
                              </div>
                            </div>
                          @endforeach
                        @endif
                      </div>
                    </div>
                    <!-- /Specification Data -->


                  </div>
                  <!-- /First column -->

                  <!-- Second column -->
                  <div class="col-12 col-lg-4">


                    <!-- Pricing Card -->
                    <div class="card mb-4">
                      <div class="card-header">
                        <h5 class="card-title mb-0">{{__('lang.admin_pricing')}}</h5>
                      </div>
                      <div class="card-body">
                          
                        <!-- Maximum Price -->
                        <div class="mb-3">
                          <label class="form-label" for="ecommerce-product-price">{{__('lang.admin_item_maximum_price')}} <span class="required">*</span></label>
                          <input
                            type="number"
                            name="maximum_price"
                            class="form-control"
                            id="price_id"
                            value="{{ $result->maximum_price }}"
                            placeholder="{{__('lang.admin_item_maximum_price')}}"
                            aria-label="{{__('lang.admin_item_maximum_price')}}" required/>
                        </div>
                        
                        <!-- Minimum Price -->
                        <div class="mb-3">
                          <label class="form-label" for="ecommerce-product-price">{{__('lang.admin_item_minimum_price')}} <span class="required">*</span></label>
                          <input
                            type="number"
                            name="minimum_price"
                            value="{{ $result->minimum_price }}"
                            class="form-control"
                            id="price_id"
                            placeholder="{{__('lang.admin_item_minimum_price')}}"
                            aria-label="{{__('lang.admin_item_minimum_price')}}" required/>
                        </div>

                        <!-- Item Price -->
                        <div class="mb-3">
                          <label class="form-label" for="ecommerce-product-price">{{__('lang.admin_item_price')}} <span class="required">*</span></label>
                          <input
                            type="number"
                            name="price"
                            class="form-control"
                            id="price_id"
                            value="{{ $result->price }}"
                            placeholder="{{__('lang.admin_item_price')}}"
                            aria-label="{{__('lang.admin_item_price')}}" required/>
                        </div>

                        <!-- Type -->
                        <div class="mb-3 col ecommerce-select2-dropdown">
                          <label class="form-label mb-1" for="vendor">{{__('lang.admin_type')}} <span class="required">*</span></label>
                          <select class="select2 form-select" name="type">
                            <option value="">{{__('lang.admin_select_type')}}</option>
                                @if(count($getType))
                                    @foreach($getType as $value => $label)
                                        <option value="{{ $value }}" {{ $value == $result->type ? 'selected' : '' }}>{{ $label }}</option>
                                    @endforeach
                                @endif
                          </select>
                        </div>
                        
                        <!-- Item Service Charge -->
                        <div class="mb-3">
                          <label class="form-label" for="ecommerce-product-price">{{__('lang.admin_service_charge')}} <span class="required">*</span></label>
                          <input
                            type="number"
                            name="service_charge"
                            class="form-control"
                            id="service_charge"
                            value="{{ $result->service_charge }}"
                            placeholder="{{__('lang.admin_service_charge')}}"
                            aria-label="{{__('lang.admin_service_charge')}}" required/>
                        </div>
                        
                        <!-- Item Tax Fees -->
                        <div class="mb-3">
                          <label class="form-label" for="ecommerce-product-price">{{__('lang.admin_tax_fees')}} <span class="required">*</span></label>
                          <input
                            type="number"
                            name="tax_fees"
                            class="form-control"
                            id="tax_fees"
                            value="{{ $result->tax_fees }}"
                            placeholder="{{__('lang.admin_tax_fees')}}"
                            aria-label="{{__('lang.admin_tax_fees')}}" required/>
                        </div>
        
                      </div>
                    </div>
                    <!-- /Pricing Card -->


                    <!-- Site Info -->
                    <div class="card mb-4">
                      <div class="card-header">
                        <h5 class="card-title mb-0">{{__('lang.admin_site_info')}}</h5>
                      </div>
                      <div class="card-body">
                          
                        <!-- Room -->
                        <div class="mb-3 col ecommerce-select2-dropdown">
                          <label class="form-label mb-1" for="vendor">{{__('lang.admin_room')}}</label>
                          <select class="select2 form-select" name="room">
                                <option value="">{{__('lang.admin_select_room')}}</option>
                                {!! \Helpers::fiftyCountData($result->room) !!}
                          </select>
                        </div>
                        
                        <!-- BedRoom -->
                        <div class="mb-3 col ecommerce-select2-dropdown">
                          <label class="form-label mb-1" for="vendor">{{__('lang.admin_bedrooms')}}</label>
                          <select class="select2 form-select" name="bedrooms">
                                <option value="">{{__('lang.admin_select_bedrooms')}}</option>
                                {!! \Helpers::fiftyCountData($result->bedrooms) !!}
                          </select>
                        </div>
                        
                        <!-- Beds -->
                        <div class="mb-3 col ecommerce-select2-dropdown">
                          <label class="form-label mb-1" for="vendor">{{__('lang.admin_beds')}}</label>
                          <select class="select2 form-select" name="beds">
                                <option value="">{{__('lang.admin_select_beds')}}</option>
                                {!! \Helpers::fiftyCountData($result->beds) !!}
                          </select>
                        </div>
                        
                        <!-- Bathrooms -->
                        <div class="mb-3 col ecommerce-select2-dropdown">
                          <label class="form-label mb-1" for="vendor">{{__('lang.admin_bathrooms')}}</label>
                          <select class="select2 form-select" name="bathrooms">
                                <option value="">{{__('lang.admin_select_bathrooms')}}</option>
                                {!! \Helpers::fiftyCountData($result->bathrooms) !!}
                          </select>
                        </div>
                          
                        <!-- Adults -->
                        <div class="mb-3 col ecommerce-select2-dropdown">
                          <label class="form-label mb-1" for="vendor">{{__('lang.admin_guest')}}</label>
                          <select class="select2 form-select" name="max_guest">
                                <option value="">{{__('lang.admin_select_guest')}}</option>
                                {!! \Helpers::fiftyCountData($result->max_guest) !!}
                          </select>
                        </div>

        
                      </div>
                    </div>
                    <!-- /Site Info -->
                    
                    <!-- Category & Aminty Info -->
                    <div class="card mb-4">
                      <div class="card-header">
                        <h5 class="card-title mb-0">{{__('lang.admin_category_and_aminity_info')}}</h5>
                      </div>
                      <div class="card-body">
                        <!-- Aminity -->
                        <div class="mb-3 col ecommerce-select2-dropdown">
                          <label
                            class="form-label mb-1 d-flex justify-content-between align-items-center"
                            for="category-org">
                          <span>{{__('lang.admin_aminity')}}</span><a href="{{url('admin/aminity')}}" class="fw-medium">{{__('lang.admin_add_new_aminity')}}</a>
                          </label>
                          <select class="select2 form-select" multiple name="aminities_id[]">
                                <option value="">{{__('lang.admin_select_aminity')}}</option>
                                @if(count($aminity_data))
                                    @foreach($aminity_data as $row)
                                        <option {{ in_array($row->id, $result->aminities->pluck('id')->toArray()) ? 'selected' : '' }} value="{{$row->id}}">{{$row->name}}</option>
                                    @endforeach
                                @endif
                          </select>
                        </div>
        
                      </div>
                    </div>
                    <!-- /Category & Aminty Info -->
                    
                    <!-- Feature Info -->
                    <div class="card mb-4">
                      <div class="card-header">
                        <h5 class="card-title mb-0">{{__('lang.admin_feature_info')}}</h5>
                      </div>
                      <div class="card-body">
                        
                        <!-- Rules -->
                        <div class="mb-3 col ecommerce-select2-dropdown">
                          <label
                            class="form-label mb-1 d-flex justify-content-between align-items-center"
                            for="category-org">
                            <span>{{__('lang.admin_rules')}}</span><a href="{{url('admin/rules')}}" class="fw-medium">{{__('lang.admin_add_new_rules')}}</a>
                          </label>
                          <select class="select2 form-select" multiple name="rules_id[]">
                            <option value="">{{__('lang.admin_select_rules')}}</option>
                            @if(count($rules_data))
                            @foreach($rules_data as $row)
                            <option {{ in_array($row->id, $result->hotelRules->pluck('rules_id')->toArray()) ? 'selected' : '' }} value="{{$row->id}}">{{$row->name}}</option>
                            @endforeach
                            @endif
                          </select>
                        </div>
                        
                        <!-- Smoking Type -->
                        <div class="mb-3 col ecommerce-select2-dropdown">
                          <label class="form-label mb-1" for="vendor">{{__('lang.admin_smoking_type')}} <span class="required">*</span></label>
                          <select class="select2 form-select" name="smoking">
                            <option value="">{{__('lang.admin_select_smoking_type')}}</option>
                                @if(count($allowedType))
                                    @foreach($allowedType as $value => $label)
                                        <option value="{{ $value }}" {{ $value == $result->smoking ? 'selected' : '' }}>{{ $label }}</option>
                                    @endforeach
                                @endif
                          </select>
                        </div>
                        
                        <!-- Pets Type -->
                        <div class="mb-3 col ecommerce-select2-dropdown">
                          <label class="form-label mb-1" for="vendor">{{__('lang.admin_pets')}} <span class="required">*</span></label>
                          <select class="select2 form-select" name="pets">
                            <option value="">{{__('lang.admin_select_pets')}}</option>
                                @if(count($allowedType))
                                    @foreach($allowedType as $value => $label)
                                        <option value="{{ $value }}" {{ $value == $result->pets ? 'selected' : '' }}>{{ $label }}</option>
                                    @endforeach
                                @endif
                          </select>
                        </div>
                        
                        <!-- Parties Events Type -->
                        <div class="mb-3 col ecommerce-select2-dropdown">
                          <label class="form-label mb-1" for="vendor">{{__('lang.admin_parties_events')}} <span class="required">*</span></label>
                          <select class="select2 form-select" name="parties_events">
                            <option value="">{{__('lang.admin_select_parties_events')}}</option>
                                @if(count($allowedType))
                                    @foreach($allowedType as $value => $label)
                                        <option value="{{ $value }}" {{ $value == $result->parties_events ? 'selected' : '' }}>{{ $label }}</option>
                                    @endforeach
                                @endif
                          </select>
                        </div>
                        
                        <!-- Type -->
                        <div class="mb-3 col ecommerce-select2-dropdown">
                          <label class="form-label mb-1" for="vendor">{{__('lang.admin_recommended')}} <span class="required">*</span></label>
                          <select class="select2 form-select" name="is_recommended">
                            <option value="">{{__('lang.admin_select_recommended')}}</option>
                                @if(count($recommendedType))
                                    @foreach($recommendedType as $value => $label)
                                        <option value="{{ $value }}" {{ $value == $result->is_recommended ? 'selected' : '' }}>{{ $label }}</option>
                                    @endforeach
                                @endif
                          </select>
                        </div>

                      </div>
                    </div>
                    <!-- /Feature Info -->

                    
                    <!-- Images -->
                    @if($result && $result->hotelImages->count())
                    <div class="card mb-4">
                        <div class="card-header">
                            <h5 class="card-title mb-0">{{__('lang.admin_images')}}</h5>
                        </div>
                        <div class="card-body">
                            <!-- Profile Image -->
                            <div class="mb-3">
                                <label class="form-label image_lable" for="ecommerce-category-image">{{__('lang.admin_upload_images')}} <span class="required">*</span></label>
                                <div class="avatar-upload">
                                    @foreach($result->hotelImages as $image)
                                    <div class="avatar-preview">
                                        <div id="imageUpload" style='background-image: url("{{asset('/uploads/hotel/images/'.$image->images)}}");'>
                                          </div>
                                      </div>
                                    @endforeach 
                                    <div class="avatar-edit">
                                        <input type='file' id="imageUploadThree" accept=".png, .jpg, .jpeg" name="images[]" multiple>
                                        <label for="imageUploadThree"><i class="ti ti-pencil me-1 pencil_for_img_upload"></i></label>
                                    </div>
                                    <div class="avatar-preview" id="imagePreviewContainer">
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    @endif
                    <!-- /Images -->


                  </div>
                  <!-- /Second column -->
                </div>
        <!-- end Hotel add -->

    </form>
       

    </div>
    <!-- / Content -->
</div>
<!-- Content wrapper -->

@endsection
