@extends('admin.layouts.app')
@section('content')

<!-- Content wrapper -->
<div class="content-wrapper">
    <!-- Content -->
    <div class="container-xxl flex-grow-1 container-p-y">


    <form action="{{url('admin/save-coupon')}}" method="POST" enctype="multipart/form-data">
        @csrf

        <div class="row">
            <div class="col-md-6">
                <h4 class="py-3 mb-4">
                  <span class="text-muted fw-light">
                    <a href="{{url('admin/dashboard')}}">{{__('lang.admin_dashboard')}}</a> /
                  </span><span class="text-muted fw-light">
                    <a href="{{url('admin/coupon')}}">{{__('lang.admin_coupon_list')}}</a> /
                  </span>
                  {{__('lang.admin_add_coupon_form')}}</h4>
            </div>
            <div class="col-md-6">
                <div class="table-btn-css">
                    <button type="submit" class="btn btn-primary waves-effect waves-light">
                        <span class="ti-xs ti ti-plus me-1"></span>{{__('lang.admin_submit')}}
                    </button>
                    <a type="reset" class="btn btn-outline-secondary" href="{{url('admin/coupon')}}">{{__('lang.admin_back')}}</a>
                </div>
            </div>
        </div>
        

        <!-- Coupon add -->
          <div class="row">

            <!-- First column-->
            <div class="col-12 col-lg-12">

              <!-- Coupon Information -->
              <div class="card mb-4">

                <div class="card-body row">
                  <!-- Title -->
                  <div class="mb-3 col-sm-4">
                    <label class="form-label" for="ecommerce-product-name">{{__('lang.admin_title')}} <span class="required">*</span></label>
                    <input
                      type="text"
                      class="form-control"
                      id="ecommerce-product-name"
                      placeholder="{{__('lang.admin_coupon_title_placeholder')}}"
                      name="title"
                      aria-label="{{__('lang.admin_title')}}" required/>
                  </div>

                  <!-- Code -->
                  <div class="mb-3 col-sm-4">
                    <label class="form-label" for="ecommerce-product-name">{{__('lang.admin_code')}} <span class="required">*</span></label>
                    <input
                      type="text"
                      class="form-control"
                      id="ecommerce-product-name"
                      placeholder="{{__('lang.admin_coupon_code_placeholder')}}"
                      name="code"
                      aria-label="{{__('lang.admin_code')}}" required/>
                  </div>

                  <!-- Coupon Type -->
                  <div class="mb-3 col col-sm-4">
                    <label class="form-label mb-1" for="vendor">{{__('lang.admin_coupon_type')}} <span class="required">*</span></label>
                    <select class="select2 form-select" name="coupon_type" required>
                      <option value="">{{__('lang.admin_select_coupon_type')}}</option>
                      @if(count($couponTypes))
                      @foreach($couponTypes as $value => $label)
                          <option value="{{ $value }}">{{ $label }}</option>
                      @endforeach
                      @endif
                    </select>
                  </div>

                  <!-- Hotel -->
                  <div class="mb-3 col-md-6 col ecommerce-select2-dropdown">
                    <label class="form-label mb-1" for="status-org"> {{__('lang.admin_hotel')}} <span class="required">*</span></label>
                    <select class="select2 form-select select2-hidden-accessible" multiple name="hotel_id[]" required>
                        @if(count($hotelData))
                        @foreach($hotelData as $row)
                        <option value="{{$row->id}}">{{$row->name}}</option>
                        @endforeach
                        @endif
                      </select>
                  </div>

                  <!--Customer-->
                  <div class="mb-3 col-md-6 col ecommerce-select2-dropdown">
                    <label class="form-label mb-1" for="status-org"> {{__('lang.admin_customer')}} <span class="required">*</span></label>
                    <select class="select2 form-select select2-hidden-accessible" multiple name="customer_id[]" required>
                        @if(count($customerData))
                        @foreach($customerData as $row)
                        <option value="{{$row->id}}">{{$row->name}}</option>
                        @endforeach
                        @endif
                      </select>
                  </div>
                  
                  <!-- Limit -->
                  <div class="mb-3 col-sm-4">
                    <label class="form-label" for="ecommerce-product-name">{{__('lang.admin_limit_for_same_user')}} <span class="required">*</span></label>
                    <input
                      type="number"
                      min="0"
                      class="form-control"
                      id="ecommerce-product-name"
                      placeholder="{{__('lang.admin_coupon_code_placeholder')}}"
                      value="0"
                      name="limit_for_same_user"
                      aria-label="{{__('lang.admin_limit_for_same_user')}}" required/>
                  </div>

                  <!-- Start date -->
                  <div class="mb-3 col-md-4">
                      <label class="form-label" for="ecommerce-product-name">{{__('lang.admin_start_date')}} <span class="required">*</span></label>
                      <input type="date" class="form-control" name="start_date">
                  </div>
                   
                  <!-- Expire date -->
                  <div class="mb-3 col-md-4">
                      <label class="form-label" for="ecommerce-product-name">{{__('lang.admin_expire_date')}} <span class="required">*</span></label>
                      <input type="date" class="form-control" name="expire_date">
                  </div>
                 
                  <!-- Discount type -->
                  <div class="mb-3 col-md-4">
                      <label class="form-label" for="ecommerce-product-name">{{__('lang.admin_discount_type')}} <span class="required">*</span></label>
                      <select class="form-control select2 form-select check_discount_type" name="discount_type" required>
                          <option value="">{{__('lang.admin_item_discount_type')}}</option>
                          @if(count($discountTypes))
                          @foreach($discountTypes as $value => $label)
                              <option value="{{$value}}">{{$label}}</option>
                          @endforeach
                          @endif
                      </select>
                  </div>

                  <!-- Discount -->
                  <div class="mb-3 col-md-4">
                    <label class="form-label" for="ecommerce-product-name">{{__('lang.admin_discount')}} <span class="required">*</span></label>
                    <input
                      type="number"
                      min="0"
                      class="form-control"
                      id="ecommerce-product-name"
                      value="0"
                      name="discount"
                      aria-label="{{__('lang.admin_discount')}}" required/>
                  </div>

                  <!-- Max Discount -->
                  <div class="mb-3 col-md-4">
                    <label class="form-label" for="ecommerce-product-name">{{__('lang.admin_max_discount')}} <span class="required">*</span></label>
                    <input
                      type="number"
                      min="0"
                      class="form-control max_discount_cls"
                      id="ecommerce-product-name"
                      value="0"
                      name="max_discount"
                      aria-label="{{__('lang.admin_max_discount')}}" required/>
                  </div>

                </div>
              </div>
              <!-- /Coupon Information -->

            </div>
            <!-- /First column -->

          </div>
        <!-- end coupon add -->

    </form>
       

    </div>
    <!-- / Content -->
</div>
<!-- Content wrapper -->

@endsection
