<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use App\Models\Category;

class SubcategoriesSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run()
    {
        $subcategoryArr = [
            array(
                'id'=>1,
                'category_id'=>1,
                'name' => 'Test SubCategory 1', 
                'slug' => \Helpers::createSlug('Test SubCategory 1','subcategory',0,false),
                'status'=> '1',
            ),
        ];


        // Insert data into the category table if the title does not exist
        foreach ($subcategoryArr as $subcat) {
            $existingCategory = DB::table('subcategories')->where('name', $subcat['name'])->first();

            if (!$existingCategory) {
                DB::table('subcategories')->insert($subcat);
            }
        }
    }
}
