<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        if (!Schema::hasTable('vendors')) {
            Schema::create('vendors', function (Blueprint $table) {
                $table->id();
                $table->enum('type', ['vendor'])->default('vendor');
                $table->enum('device_type', ['web', 'app'])->default('web');
                $table->string('language_code')->nullable();
                $table->string('name');
                $table->string('image')->nullable();
                $table->string('email')->nullable()->unique();
                $table->string('password')->nullable();
                $table->string('phone', 25)->nullable();
                $table->string('auth_token')->nullable();
                $table->string('aadhar_card_image')->nullable();
                $table->tinyInteger('status')->default(0);
                $table->tinyInteger('is_verified')->default(0);
                $table->tinyInteger('enable_notification')->default(1);
                $table->unsignedInteger('role_id')->default(3);
                $table->string('remember_token', 100)->nullable();
                $table->timestamp('email_verified_at')->nullable();
                $table->timestamps();
                $table->softDeletes();
    
                // Adding indexes for performance optimization
                $table->index('email');
                $table->index('phone');
            });
        }
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('vendors');
    }
};
