<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        if (!Schema::hasTable('coupons')) {
            Schema::create('coupons', function (Blueprint $table) {
                $table->id();
                $table->enum('added_type',['Admin','Vendor'])->default('Admin');
                $table->unsignedBigInteger('vendor_id')->default(0);
                $table->string('coupon_type',30)->nullable();
                $table->string('title',100)->nullable();
                $table->string('code',30)->nullable();
                $table->integer('limit_for_same_user')->nullable();
                $table->string('start_date',30)->nullable();
                $table->string('expire_date',30)->nullable();
                $table->enum('discount_type',['amount','percent'])->default('amount');
                $table->string('discount',30)->nullable();
                $table->string('max_discount',30)->nullable();
                $table->string('min_purchase',30)->nullable();
                $table->enum('status',[1,0])->default(1);
                $table->timestamps();
                
                $table->foreign('vendor_id')->references('id')->on('vendors')->onDelete('cascade');
            });
        }
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('coupons');
    }
};
