<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        if (!Schema::hasTable('hotel_aminities')) {
            Schema::create('hotel_aminities', function (Blueprint $table) {
                $table->id();
                $table->unsignedBigInteger('hotel_id')->default(0);
                $table->unsignedBigInteger('aminities_id')->default(0);
                $table->timestamps();
                $table->softDeletes();
                // Adding indexes
                $table->index('hotel_id');
                $table->index('aminities_id');

                // Foreign key constraints
                $table->foreign('hotel_id')->references('id')->on('hotels')->onDelete('cascade');
                $table->foreign('aminities_id')->references('id')->on('aminities')->onDelete('cascade');
            });
        }
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('hotel_aminities');
    }
};
