<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        if (!Schema::hasTable('cancellation_policy')) {
            Schema::create('cancellation_policy', function (Blueprint $table) {
                $table->id();
                $table->unsignedBigInteger('hotel_id')->default(0);
                $table->text('title')->nullable();
                $table->timestamps();
                $table->softDeletes();
                
                // Adding indexes
                $table->index('hotel_id');
                $table->index('title');
                
                // Foreign key constraints
                $table->foreign('hotel_id')->references('id')->on('hotels')->onDelete('cascade');
            });
        }
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('cancellation_policy');
    }
};
