<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        if (!Schema::hasTable('subcategories')) {
            Schema::create('subcategories', function (Blueprint $table) {
                $table->id();
                $table->unsignedBigInteger('category_id')->default(0);
                $table->string('name')->nullable();
                $table->string('slug')->nullable();
                $table->enum('status',[1,0])->default(1);
                $table->timestamps();
                $table->softDeletes();
                // Adding indexes
                $table->index('name');
                $table->index('slug');
                $table->index('status');

                // Foreign key constraints
                $table->foreign('category_id')->references('id')->on('categories')->onDelete('cascade');
            });
        }
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('subcategories');
    }
};
