<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class CancelBooking extends Model
{
    use HasFactory, SoftDeletes;
    protected $table = 'cancel_booking';
    protected $fillable = [
        'user_id',
        'hotel_id',
        'booking_id',
        'reason',
        'details',
        'status',
    ];

    public function user()
    {
        return $this->belongsTo(User::class);
    }

    public function hotel()
    {
        return $this->belongsTo(Hotel::class);
    }
    
    public function booking()
    {
        return $this->belongsTo(Booking::class);
    }
}

