<?php

namespace RachidLaasri\LaravelInstaller\Helpers;

use Exception;
use Illuminate\Http\Request;
use Illuminate\Support\Str;

class EnvironmentManager
{
    /**
     * @var string
     */
    private $envPath;

    /**
     * @var string
     */
    private $envExamplePath;

    /**
     * Set the .env and .env.example paths.
     */
    public function __construct()
    {
        $this->envPath = base_path('.env');
        $this->envExamplePath = base_path('.env.example');
    }

    /**
     * Get the content of the .env file.
     *
     * @return string
     */
    public function getEnvContent()
    {
        if (! file_exists($this->envPath)) {
            if (file_exists($this->envExamplePath)) {
                copy($this->envExamplePath, $this->envPath);
            } else {
                touch($this->envPath);
            }
        }

        return file_get_contents($this->envPath);
    }

    /**
     * Get the the .env file path.
     *
     * @return string
     */
    public function getEnvPath()
    {
        return $this->envPath;
    }

    /**
     * Get the the .env.example file path.
     *
     * @return string
     */
    public function getEnvExamplePath()
    {
        return $this->envExamplePath;
    }

    /**
     * Save the edited content to the .env file.
     *
     * @param Request $input
     * @return string
     */
    public function saveFileClassic(Request $input)
    {
        $message = 'Your .env file settings have been saved.';
        $input->app_installed = true;
        $envFileData =
        'APP_NAME=\''.$input->app_name."'\n".
        'APP_ENV='.$input->environment."\n".
        'APP_KEY='.'base64:'.base64_encode(Str::random(32))."\n".
        'APP_DEBUG='.$input->app_debug."\n".
        'APP_INSTALLED='.$input->app_installed."\n".
        'APP_LOG_LEVEL='.$input->app_log_level."\n".
        'APP_URL='.$input->app_url."\n\n".
        'DB_CONNECTION='.$input->database_connection."\n".
        'DB_HOST='.$input->database_hostname."\n".
        'DB_PORT='.$input->database_port."\n".
        'DB_DATABASE='.$input->database_name."\n".
        'DB_USERNAME='.$input->database_username."\n".
        'DB_PASSWORD='.$input->database_password."\n\n".
        'BROADCAST_DRIVER='.$input->broadcast_driver."\n".
        'CACHE_DRIVER='.$input->cache_driver."\n".
        'SESSION_DRIVER='.$input->session_driver."\n".
        'QUEUE_DRIVER='.$input->queue_driver."\n\n".
        'REDIS_HOST='.$input->redis_hostname."\n".
        'REDIS_PASSWORD='.$input->redis_password."\n".
        'REDIS_PORT='.$input->redis_port."\n\n".
        'MAIL_DRIVER='.$input->mail_driver."\n".
        'MAIL_HOST='.$input->mail_host."\n".
        'MAIL_PORT='.$input->mail_port."\n".
        'MAIL_USERNAME='.$input->mail_username."\n".
        'MAIL_PASSWORD='.$input->mail_password."\n".
        'MAIL_ENCRYPTION='.$input->mail_encryption."\n\n".
        'PUSHER_APP_ID='.$input->pusher_app_id."\n".
        'PUSHER_APP_KEY='.$input->pusher_app_key."\n".
        'PUSHER_APP_SECRET='.$input->pusher_app_secret."\n".
        'CODE_VERIFIED='."false \n".
        'GOOGLE_CLIENT_ID='."null \n".
        'GOOGLE_CLIENT_SECRET='."null";

        try {
            file_put_contents($this->envPath, $envFileData);
        } catch (Exception $e) {
            $message = 'Unable to save the .env file, Please create it manually.';
        }

        return $message;
    }

    /**
     * Save the form content to the .env file.
     *
     * @param Request $request
     * @return string
     */
    public function saveFileWizard(Request $request)
    {
        $results = 'Your .env file settings have been saved.';
        $request->app_installed = true;
        $envFileData =
        'APP_NAME=\''.$request->app_name."'\n".
        'APP_ENV='.$request->environment."\n".
        'APP_KEY='.'base64:'.base64_encode(Str::random(32))."\n".
        'APP_DEBUG='.$request->app_debug."\n".
        'APP_INSTALLED='.$request->app_installed."\n".
        'APP_LOG_LEVEL='.$request->app_log_level."\n".
        'APP_URL='.$request->app_url."\n\n".
        'DB_CONNECTION='.$request->database_connection."\n".
        'DB_HOST='.$request->database_hostname."\n".
        'DB_PORT='.$request->database_port."\n".
        'DB_DATABASE='.$request->database_name."\n".
        'DB_USERNAME='.$request->database_username."\n".
        'DB_PASSWORD='.$request->database_password."\n\n".
        'BROADCAST_DRIVER='.$request->broadcast_driver."\n".
        'CACHE_DRIVER='.$request->cache_driver."\n".
        'SESSION_DRIVER='.$request->session_driver."\n".
        'QUEUE_DRIVER='.$request->queue_driver."\n\n".
        'REDIS_HOST='.$request->redis_hostname."\n".
        'REDIS_PASSWORD='.$request->redis_password."\n".
        'REDIS_PORT='.$request->redis_port."\n\n".
        'MAIL_DRIVER='.$request->mail_driver."\n".
        'MAIL_HOST='.$request->mail_host."\n".
        'MAIL_PORT='.$request->mail_port."\n".
        'MAIL_USERNAME='.$request->mail_username."\n".
        'MAIL_PASSWORD='.$request->mail_password."\n".
        'MAIL_ENCRYPTION='.$request->mail_encryption."\n\n".
        'PUSHER_APP_ID='.$request->pusher_app_id."\n".
        'PUSHER_APP_KEY='.$request->pusher_app_key."\n".
        'PUSHER_APP_SECRET='.$request->pusher_app_secret."\n".
        'CODE_VERIFIED='.$request->code_verified."\n".
        'GOOGLE_CLIENT_ID='.$request->google_client_id."\n".
        'GOOGLE_CLIENT_SECRET='.$request->google_client_secret;

        try {
            file_put_contents($this->envPath, $envFileData);
        } catch (Exception $e) {
            $results = 'Unable to save the .env file, Please create it manually.';
        }

        return $results;
    }
}
