<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\Contentwarehouse;

class AppsPeopleOzExternalMergedpeopleapiReadOnlyProfileInfoDomainInfo extends \Google\Collection
{
  protected $collection_key = 'domainName';
  /**
   * @var string[]
   */
  public $domainBadge;
  /**
   * @var string[]
   */
  public $domainName;

  /**
   * @param string[]
   */
  public function setDomainBadge($domainBadge)
  {
    $this->domainBadge = $domainBadge;
  }
  /**
   * @return string[]
   */
  public function getDomainBadge()
  {
    return $this->domainBadge;
  }
  /**
   * @param string[]
   */
  public function setDomainName($domainName)
  {
    $this->domainName = $domainName;
  }
  /**
   * @return string[]
   */
  public function getDomainName()
  {
    return $this->domainName;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(AppsPeopleOzExternalMergedpeopleapiReadOnlyProfileInfoDomainInfo::class, 'Google_Service_Contentwarehouse_AppsPeopleOzExternalMergedpeopleapiReadOnlyProfileInfoDomainInfo');
